﻿#
# Read current measured values example
#
# Requirements: Python 3.8.3 ( www.python.org )
#               P2520 device with firmware version 7-5-1-0 or higher
#
#  Purpose of this example is demonstration of communication with P2520 device.
#  It is not intended to be used in production environment without further changes.
#

#Connection parameters
TCP_IP = '192.168.1.213'
TCP_PORT = 502

import socket, struct

sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
sock.connect((TCP_IP, TCP_PORT))

try:
    req = struct.pack('12B', 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x01, 0x03, 0x9C, 0x2F, 0x00, 0x02)
    #send ModbusTCP request
    sock.send(req)
    '''
    Modbus TCP request:
       0x00 0x00 0x00 0x00 - transaction ID + protocol ID
       0x00 0x06           - length of following bytes
       0x01                - unit ID
       0x03                - function code (read holding registers)
       0x9C 0x2F           - register address (from manual - 0x9C2F=channel 1)
       0x00 0x02           - number of registers for reading (two channels)
    '''

    #read ModbusTCP response
    rcv = sock.recv(64)
    #decode response
    out = struct.unpack(">IHccchh", rcv)
    print("Channel 1:", out[5]/10,
          "\nChannel 2:", out[6]/10)
    '''
    Modbus TCP response:
       0x00 0x00 0x00 0x00 - transaction ID + protocol ID
       0x00 0x07           - length of following bytes
       0x01                - unit ID
       0x03                - function code (read holding registers)
       0x04                - bytes count (=2x2)
       0x01 0x62 0x00 0xF0 - response data
          0x01 0x62 = 354 = 35.4%RH at channel 1
          0x00 0xF0 = 240 = 24.0°C at channel 2
    '''
    
finally:
    sock.close()
