#
# Simple HTTP server to reading SOAP messages from P2520 device
#
# Requirements: Python 3.8.3 ( www.python.org )
#               P2520 device with firmware version 7-5-1-0 or higher
#               Allowed port in firewall
#
#  Purpose of this example is demonstration of communication with P2520 device.
#  It is not intended to be used in production environment without further changes.
#

# TCP port for http server
PORT = 8080

from http.server import BaseHTTPRequestHandler, HTTPServer
import xml.etree.ElementTree as ET

class HTTPServer_RequestHandler(BaseHTTPRequestHandler):

    # POST request handler
    def do_POST(self):
        # read POST data
        length = int(self.headers['Content-Length'])
        data = self.rfile.read(length).decode()
        print('POST-path:', self.path, ', POST-data-len:', length)
        #print(data)

        # parse XML in POST data
        xmldoc = ET.fromstring(data)[0][0]
        for child in xmldoc:
            for el in child:
                # for enabled channels only
                if (el.tag.endswith('e') > 0) & (el.text=='1'):
                    for el2 in child:
                        # name of channel
                        if el2.tag.endswith('n') > 0:
                            name = el2.text
                        # unit
                        if el2.tag.endswith('u') > 0:
                            unit = el2.text
                        # value
                        if el2.tag.endswith('v') > 0:
                            value = el2.text;

                    # print output in console
                    print(name+": "+value+unit)

        # send back response do device (HTTP/1.1 is mandatory)
        self.protocol_version = 'HTTP/1.1'
        self.send_response(200)
        self.end_headers()
        return

    # disable server log messages
    def log_message(self, format, *args):
        return

# run HTTP server
def run():
    print('Starting HTTP server...')
    httpd = HTTPServer(("", PORT), HTTPServer_RequestHandler)
    httpd.serve_forever()

run()
